<?php include 'header.php'; ?>

<!-- Breadcrumb Navigasi -->
<div class="mb-6 text-sm">
    <a href="index.php" class="text-blue-600 hover:text-blue-800">Daftar Sekolah</a>
    <span class="text-gray-400 mx-2">/</span>
    <a href="index.php?action=view_class&school_id=<?php echo $class['school_id']; ?>" class="text-blue-600 hover:text-blue-800">Kelas di <?php echo htmlspecialchars($school['name']); ?></a>
    <span class="text-gray-400 mx-2">/</span>
    <a href="index.php?action=view_class_dashboard&class_id=<?php echo $class_id; ?>" class="text-blue-600 hover:text-blue-800">Dashboard</a>
    <span class="text-gray-400 mx-2">/</span>
    <span class="text-gray-600 font-semibold">Input Nilai</span>
</div>

<!-- Judul Halaman -->
<div class="mb-6 border-b pb-4">
    <h2 class="text-2xl font-bold text-gray-800 mb-2">Input Nilai untuk: <?php echo htmlspecialchars($student['name']); ?></h2>
    <p class="text-gray-600">Kelas: <?php echo htmlspecialchars($student['class_name']); ?> | KKM: <?php echo $student['kktp']; ?></p>
</div>

<!-- Form Input Nilai -->
<form method="POST" action="index.php?action=grade_student&student_id=<?php echo $student_id; ?>" class="space-y-8">
    <!-- Section 1: Input Jawaban Benar Siswa (Tes Global) -->
    <div class="space-y-4 bg-green-50 p-6 rounded-xl border-l-4 border-green-500">
        <p class="text-xl font-bold text-green-800 mb-4">
            <svg class="inline-block w-6 h-6 mr-2" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
            1. Input Jawaban Benar Siswa (Tes Global)
        </p>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700">PG Benar (Max <?php echo $assessment['pg_total']; ?>)</label>
                <input type="number" name="pg_benar" min="0" max="<?php echo $assessment['pg_total']; ?>" required class="mt-1 p-2 block w-full border-gray-300 rounded-md shadow-sm">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700">Isian Benar (Max <?php echo $assessment['isian_total']; ?>)</label>
                <input type="number" name="isian_benar" min="0" max="<?php echo $assessment['isian_total']; ?>" required class="mt-1 p-2 block w-full border-gray-300 rounded-md shadow-sm">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700">Essay Benar (Max <?php echo $assessment['essay_total']; ?>)</label>
                <input type="number" name="essay_benar" min="0" max="<?php echo $assessment['essay_total']; ?>" required class="mt-1 p-2 block w-full border-gray-300 rounded-md shadow-sm">
            </div>
        </div>
    </div>

    <!-- Section 2: Input Nilai SLM/UH per Bab -->
    <div class="space-y-4 bg-purple-50 p-6 rounded-xl border-l-4 border-purple-500">
        <p class="text-xl font-bold text-purple-800 mb-4">
            <svg class="inline-block w-6 h-6 mr-2" fill="currentColor" viewBox="0 0 20 20"><path d="M9 2a1 1 0 000 2h2a1 1 0 100-2H9z"></path><path fill-rule="evenodd" d="M4 5a2 2 0 012-2 1 1 0 000 2H6a2 2 0 100 4h2a2 2 0 100 4h2a1 1 0 100 2 2 2 0 01-2 2H6a2 2 0 01-2-2V5z" clip-rule="evenodd"></path></svg>
            2. Input Nilai SLM/UH per Bab
        </p>
        <?php foreach($assessment_config['chapters'] as $chapter): ?>
            <div class="flex items-center gap-4 p-3 bg-white rounded-lg shadow-sm">
                <label for="slm_<?php echo $chapter['id']; ?>" class="flex-1 text-sm font-medium text-gray-700">Nilai SLM <?php echo htmlspecialchars($chapter['name']); ?>:</label>
                <input type="number" name="slm_scores[<?php echo $chapter['id']; ?>]" id="slm_<?php echo $chapter['id']; ?>" min="0" max="100" required class="p-2 w-32 border-gray-300 rounded-md shadow-sm">
            </div>
        <?php endforeach; ?>
    </div>

    <!-- Tombol Simpan -->
    <div class="flex justify-end">
        <button type="submit" name="submit_grades" class="bg-red-600 hover:bg-red-700 text-white font-bold py-3 px-6 rounded-lg text-lg transition shadow-sm">
            Hitung & Simpan Nilai
        </button>
    </div>
</form>

<?php include 'footer.php'; ?>