<?php include 'header.php'; ?>

<!-- Breadcrumb Navigasi -->
<div class="mb-6 text-sm">
    <a href="index.php" class="text-blue-600 hover:text-blue-800">Daftar Sekolah</a>
    <span class="text-gray-400 mx-2">/</span>
    <a href="index.php?action=view_class&school_id=<?php echo $school['id']; ?>" class="text-blue-600 hover:text-blue-800">Kelas di <?php echo htmlspecialchars($school['name']); ?></a>
    <span class="text-gray-400 mx-2">/</span>
    <a href="index.php?action=view_class_dashboard&class_id=<?php echo $class_id; ?>" class="text-blue-600 hover:text-blue-800">Dashboard</a>
    <span class="text-gray-400 mx-2">/</span>
    <span class="text-gray-600 font-semibold">Konfigurasi Asesmen</span>
</div>

<!-- Judul Halaman -->
<div class="mb-6 border-b pb-4">
    <h2 class="text-2xl font-bold text-gray-800">Konfigurasi Asesmen untuk: <?php echo htmlspecialchars($class['name']); ?></h2>
    <p class="text-gray-600">KKM: <?php echo $class['kktp']; ?></p>
</div>

<!-- Progress Bar -->
<div class="mb-8 p-4 bg-gray-50 rounded-xl shadow-inner border border-gray-200">
    <div class="flex justify-between items-center mb-2">
        <span class="text-sm font-medium text-gray-700">Langkah <?php echo $step; ?> dari 3</span>
        <span class="text-sm font-medium text-gray-700"><?php echo ($step == 1) ? 'Jumlah Bab' : (($step == 2) ? 'Detail Bab & TP' : 'Detail TP & Soal'); ?></span>
    </div>
    <div class="w-full bg-gray-200 rounded-full h-2.5">
        <div class="bg-red-600 h-2.5 rounded-full transition-all duration-300" style="width: <?php echo ($step / 3) * 100; ?>%"></div>
    </div>
</div>

<!-- Form Multi-Step -->
<?php if ($step == 1): ?>
    <form method="POST" action="index.php?action=configure_assessment&class_id=<?php echo $class_id; ?>&step=2" class="space-y-6">
        <div class="bg-blue-50 p-6 rounded-xl">
            <h3 class="text-lg font-bold text-blue-800 mb-4">1. Tentukan Jumlah Bab/Unit</h3>
            <div>
                <label for="chapter_count" class="block text-sm font-medium text-gray-700">Berapa jumlah Bab yang akan Anda nilai?</label>
                <input type="number" id="chapter_count" name="chapter_count" min="1" max="10" value="<?php echo $config['chapter_count'] ?? 2; ?>" required class="mt-1 p-3 block w-full border-gray-300 rounded-md text-xl font-semibold">
            </div>
        </div>
        <div class="flex justify-end">
            <button type="submit" name="submit_step_1" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-6 rounded-lg">Lanjut ke Langkah 2 &rarr;</button>
        </div>
    </form>
<?php elseif ($step == 2): ?>
    <form method="POST" action="index.php?action=configure_assessment&class_id=<?php echo $class_id; ?>&step=3" class="space-y-6">
        <div class="bg-yellow-50 p-6 rounded-xl">
            <h3 class="text-lg font-bold text-yellow-800 mb-4">2. Detail untuk Setiap Bab</h3>
            <?php for ($i = 0; $i < $config['chapter_count']; $i++): ?>
                <div class="p-4 bg-white rounded-lg shadow mb-4">
                    <h4 class="font-bold text-md text-gray-700 mb-3">Bab <?php echo $i + 1; ?></h4>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Nama Bab</label>
                            <input type="text" name="chapter_name_<?php echo $i; ?>" value="<?php echo $config['chapters'][$i]['name'] ?? "Bab " . ($i+1); ?>" required class="mt-1 p-2 block w-full border-gray-300 rounded-md">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Lingkup Materi Bab</label>
                            <input type="text" name="chapter_topic_<?php echo $i; ?>" value="<?php echo $config['chapters'][$i]['topic'] ?? "Deskripsi Bab " . ($i+1); ?>" required class="mt-1 p-2 block w-full border-gray-300 rounded-md">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Jumlah TP</label>
                            <input type="number" name="tp_count_<?php echo $i; ?>" value="<?php echo $config['chapters'][$i]['tp_count'] ?? 3; ?>" min="1" max="10" required class="mt-1 p-2 block w-full border-gray-300 rounded-md">
                        </div>
                    </div>
                </div>
            <?php endfor; ?>
        </div>
        <div class="flex justify-between">
            <a href="index.php?action=configure_assessment&class_id=<?php echo $class_id; ?>&step=1" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-3 px-6 rounded-lg">&larr; Kembali</a>
            <button type="submit" name="submit_step_2" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-6 rounded-lg">Lanjut ke Langkah 3 &rarr;</button>
        </div>
    </form>
<?php elseif ($step == 3): ?>
    <form method="POST" action="index.php?action=configure_assessment&class_id=<?php echo $class_id; ?>" class="space-y-6">
        <div class="bg-green-50 p-6 rounded-xl">
            <h3 class="text-lg font-bold text-green-800 mb-4">3a. Masukkan Total Soal Global</h3>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div><label class="block text-sm font-medium text-gray-700">Total Pilihan Ganda (PG)</label><input type="number" name="pg_total" value="<?php echo $config['pg_total'] ?? 25; ?>" min="0" required class="mt-1 p-2 block w-full border-gray-300 rounded-md"></div>
                <div><label class="block text-sm font-medium text-gray-700">Total Isian Singkat</label><input type="number" name="isian_total" value="<?php echo $config['isian_total'] ?? 10; ?>" min="0" required class="mt-1 p-2 block w-full border-gray-300 rounded-md"></div>
                <div><label class="block text-sm font-medium text-gray-700">Total Essay</label><input type="number" name="essay_total" value="<?php echo $config['essay_total'] ?? 5; ?>" min="0" required class="mt-1 p-2 block w-full border-gray-300 rounded-md"></div>
            </div>
        </div>
        <div class="bg-purple-50 p-6 rounded-xl">
            <h3 class="text-lg font-bold text-purple-800 mb-4">3b. Masukkan Lingkup Materi untuk Setiap TP</h3>
            <?php foreach ($config['chapters'] as $i => $chapter): ?>
                <div class="p-4 bg-white rounded-lg shadow mb-4">
                    <h4 class="font-bold text-md text-purple-700 mb-3"><?php echo htmlspecialchars($chapter['name']); ?></h4>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                        <?php for ($j = 0; $j < $chapter['tp_count']; $j++): ?>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">TP <?php echo ($i+1) . "." . ($j+1); ?></label>
                                <input type="text" name="tp_topic_<?php echo "{$i}_{$j}"; ?>" value="<?php echo $config['chapters'][$i]['tps'][$j]['topic'] ?? "Deskripsi TP " . ($i+1) . "." . ($j+1); ?>" required class="mt-1 p-2 block w-full border-gray-300 rounded-md">
                            </div>
                        <?php endfor; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <div class="flex justify-between">
            <a href="index.php?action=configure_assessment&class_id=<?php echo $class_id; ?>&step=2" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-3 px-6 rounded-lg">&larr; Kembali</a>
            <button type="submit" name="submit_step_3" class="bg-green-600 hover:bg-green-700 text-white font-bold py-3 px-6 rounded-lg">Simpan Konfigurasi</button>
        </div>
    </form>
<?php endif; ?>

<?php include 'footer.php'; ?>