<?php include 'header.php'; ?>

<!-- Breadcrumb Navigasi -->
<div class="mb-6 text-sm">
    <a href="index.php" class="text-blue-600 hover:text-blue-800">Daftar Sekolah</a>
    <span class="text-gray-400 mx-2">/</span>
    <a href="index.php?action=view_class&school_id=<?php echo $school['id']; ?>" class="text-blue-600 hover:text-blue-800">Kelas di <?php echo htmlspecialchars($school['name']); ?></a>
    <span class="text-gray-400 mx-2">/</span>
    <a href="index.php?action=view_class_dashboard&class_id=<?php echo $class_id; ?>" class="text-blue-600 hover:text-blue-800">Dashboard</a>
    <span class="text-gray-400 mx-2">/</span>
    <span class="text-gray-600 font-semibold">Tambah Siswa Baru</span>
</div>

<!-- Judul Halaman -->
<div class="mb-6 border-b pb-4">
    <h2 class="text-2xl font-bold text-gray-800">Tambah Siswa Baru di <?php echo htmlspecialchars($class['name']); ?></h2>
</div>

<!-- Form Tambah Siswa -->
<form method="POST" action="index.php" class="space-y-6 max-w-2xl">
    <input type="hidden" name="class_id" value="<?php echo $class_id; ?>">
    
    <div>
        <label for="student_name" class="block text-sm font-medium text-gray-700">Nama Siswa</label>
        <input type="text" id="student_name" name="student_name" required class="mt-1 p-3 block w-full border-gray-300 rounded-md shadow-sm" placeholder="Masukkan nama lengkap siswa">
    </div>
    
    <div>
        <label for="student_number" class="block text-sm font-medium text-gray-700">NIS / NISN</label>
        <input type="text" id="student_number" name="student_number" required class="mt-1 p-3 block w-full border-gray-300 rounded-md shadow-sm" placeholder="Masukkan Nomor Induk Siswa">
    </div>
    
    <div class="flex gap-4">
        <button type="submit" name="add_student" class="bg-green-600 hover:bg-green-700 text-white font-bold py-3 px-6 rounded-lg transition shadow-sm">
            Simpan Siswa
        </button>
        <a href="index.php?action=view_class_dashboard&class_id=<?php echo $class_id; ?>" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-3 px-6 rounded-lg text-center transition shadow-sm">
            Batal
        </a>
    </div>
</form>

<?php include 'footer.php'; ?>