<?php
// FILE: qr_process.php - Mencatat Kehadiran dengan NISN
// Berfungsi untuk menerima NISN dari scan QR code

// Pastikan Content-Type adalah JSON
header('Content-Type: application/json');

require_once 'db.php'; 
date_default_timezone_set('Asia/Jakarta'); 

$response = [
    'success' => false,
    'message' => 'Status Kehadiran',
    'siswa_name' => '',
    'siswa_id' => null,
    'siswa_nisn' => null,
    'current_status' => '',
];

// Hanya menerima NISN dari QR code
$scanned_nisn = $_GET['nisn'] ?? ($_GET['code'] ?? null);

$tanggal = date('Y-m-d');
$bulan = date('Y-m');
$status_hadir = 'H';

if (empty($scanned_nisn)) {
    $response['message'] = "Kode QR (NISN) tidak valid atau kosong.";
    echo json_encode($response);
    exit;
}

// Validasi: Pastikan NISN hanya berisi angka
if (!is_numeric($scanned_nisn)) {
    $response['message'] = "Format NISN tidak valid. Harus berupa angka.";
    echo json_encode($response);
    exit;
}

try {
    // 1. Cari Siswa berdasarkan NISN
    $stmt_siswa = $pdo->prepare("
        SELECT siswa_id, nama, nisn 
        FROM siswa 
        WHERE nisn = ?
    ");
    $stmt_siswa->execute([$scanned_nisn]);
    $siswa = $stmt_siswa->fetch(PDO::FETCH_ASSOC);

    if (!$siswa) {
        $response['message'] = "Siswa dengan NISN **" . htmlspecialchars($scanned_nisn) . "** tidak ditemukan.";
        echo json_encode($response);
        exit;
    }

    // Set data siswa ke response
    $siswa_id = $siswa['siswa_id'];
    $response['siswa_id'] = $siswa['siswa_id'];
    $response['siswa_name'] = htmlspecialchars($siswa['nama']);
    $response['siswa_nisn'] = htmlspecialchars($siswa['nisn']);
    
    $nisn_display = " (NISN: {$siswa['nisn']})";

    // 2. Cek apakah sudah absen hari ini
    $stmt_check = $pdo->prepare("SELECT status FROM kehadiran WHERE siswa_id = ? AND tanggal = ?");
    $stmt_check->execute([$siswa_id, $tanggal]);
    $existing_status = $stmt_check->fetchColumn();

    if ($existing_status) {
        $response['success'] = true;
        $response['current_status'] = $existing_status;
        $response['message'] = "Kehadiran {$siswa['nama']}{$nisn_display} **sudah tercatat** hari ini. Status: " . $existing_status;
    } else {
        // 3. Catat Kehadiran
        $query = "INSERT INTO kehadiran (siswa_id, tanggal, status, bulan) VALUES (?, ?, ?, ?)";
        $stmt_insert = $pdo->prepare($query);
        
        if ($stmt_insert->execute([$siswa_id, $tanggal, $status_hadir, $bulan])) {
            $response['success'] = true;
            $response['current_status'] = $status_hadir;
            $response['message'] = "Kehadiran {$siswa['nama']}{$nisn_display} **BERHASIL dicatat!** Status: Hadir.";
        } else {
            $response['message'] = "Gagal mencatat kehadiran ke database.";
        }
    }

} catch (PDOException $e) {
    // Tangani error jika terjadi masalah koneksi atau query database
    $response['message'] = "Database Error: " . $e->getMessage();
}

echo json_encode($response);
?>