<?php
// Mengaktifkan Tailwind CSS melalui CDN
echo '<script src="https://cdn.tailwindcss.com"></script>';
// Mengatur font default
echo '<style>body { font-family: "Inter", sans-serif; background-color: #f4f7f9; }</style>';

// --- DEFINISI VARIABEL DAN FUNGSI UTAMA ---

$pg_total = 0;
$isian_total = 0;
$essay_total = 0;
$total_soal = 0;
$nilai_per_soal = 0;
$tahap = 1; // 1: Input jumlah soal, 2: Input jawaban benar, 3: Tampilkan hasil

// Memeriksa apakah Form 1 (Input Jumlah Soal) telah disubmit
if (isset($_POST['submit_jumlah'])) {
    // Memastikan input adalah angka positif
    $pg_total = max(0, (int)($_POST['pg_total'] ?? 0));
    $isian_total = max(0, (int)($_POST['isian_total'] ?? 0));
    $essay_total = max(0, (int)($_POST['essay_total'] ?? 0));
    
    $total_soal = $pg_total + $isian_total + $essay_total;

    if ($total_soal > 0) {
        // Hitung nilai per soal secara proporsional agar totalnya 100
        $nilai_per_soal = 100 / $total_soal;
        $tahap = 2;
    } else {
        // Jika total soal 0, kembali ke tahap 1 dengan pesan error
        $tahap = 1;
        $error_message = "Total jumlah soal harus lebih dari 0.";
    }
} 
// Memeriksa apakah Form 2 (Input Jawaban Benar) telah disubmit
elseif (isset($_POST['submit_hasil'])) {
    // Ambil data tersembunyi (hidden fields) dari form sebelumnya
    // Ini adalah data total soal yang dibawa dari Tahap 1, TEPAT SEPERTI YANG ANDA LIHAT.
    $pg_total = max(0, (int)($_POST['pg_total_hidden'] ?? 0));
    $isian_total = max(0, (int)($_POST['isian_total_hidden'] ?? 0));
    $essay_total = max(0, (int)($_POST['essay_total_hidden'] ?? 0));
    $nilai_per_soal = (float)($_POST['nilai_per_soal_hidden'] ?? 0);
    $total_soal = $pg_total + $isian_total + $essay_total;

    // Ambil input jumlah jawaban benar
    $pg_benar = max(0, min($pg_total, (int)($_POST['pg_benar'] ?? 0)));
    $isian_benar = max(0, min($isian_total, (int)($_POST['isian_benar'] ?? 0)));
    $essay_benar = max(0, min($essay_total, (int)($_POST['essay_benar'] ?? 0)));
    
    // Perhitungan Nilai
    $total_benar = $pg_benar + $isian_benar + $essay_benar;
    
    // Nilai Akhir = (Total Jawaban Benar) * (Nilai Per Soal)
    $nilai_akhir = $total_benar * $nilai_per_soal;
    
    $tahap = 3;
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kalkulator Nilai Ujian</title>
</head>
<body class="p-4 md:p-8 flex justify-center items-start min-h-screen">

    <div class="w-full max-w-lg bg-white p-6 md:p-10 shadow-xl rounded-xl">
        <h1 class="text-3xl font-bold text-center text-indigo-700 mb-6">Kalkulator Nilai Ujian (Skala 100)</h1>
        
        <?php if (isset($error_message)): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
                <span class="block sm:inline"><?php echo htmlspecialchars($error_message); ?></span>
            </div>
        <?php endif; ?>

        <?php if ($tahap === 1): ?>
            <!-- TAHAP 1: INPUT JUMLAH SOAL -->
            <p class="text-lg text-gray-600 mb-6 text-center">Langkah 1: Tentukan jumlah total soal untuk setiap kategori.</p>
            <form method="POST" action="hitung_nilai.php" class="space-y-4">
                
                <div class="flex flex-col">
                    <label for="pg_total" class="text-gray-700 font-medium mb-1">Jumlah Soal Pilihan Ganda (PG):</label>
                    <input type="number" id="pg_total" name="pg_total" required min="0" value="<?php echo htmlspecialchars($pg_total > 0 ? $pg_total : ''); ?>"
                           class="p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 transition duration-150">
                </div>

                <div class="flex flex-col">
                    <label for="isian_total" class="text-gray-700 font-medium mb-1">Jumlah Soal Isian Singkat:</label>
                    <input type="number" id="isian_total" name="isian_total" required min="0" value="<?php echo htmlspecialchars($isian_total > 0 ? $isian_total : ''); ?>"
                           class="p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 transition duration-150">
                </div>

                <div class="flex flex-col">
                    <label for="essay_total" class="text-gray-700 font-medium mb-1">Jumlah Soal Esai:</label>
                    <input type="number" id="essay_total" name="essay_total" required min="0" value="<?php echo htmlspecialchars($essay_total > 0 ? $essay_total : ''); ?>"
                           class="p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 transition duration-150">
                </div>

                <button type="submit" name="submit_jumlah" 
                        class="w-full bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-3 rounded-lg transition duration-200 shadow-md transform hover:scale-[1.01]">
                    Lanjut ke Pengisian Jawaban
                </button>
            </form>

        <?php elseif ($tahap === 2): ?>
            <!-- TAHAP 2: INPUT JAWABAN BENAR -->
            <p class="text-lg text-gray-600 mb-4 text-center">
                Langkah 2: Masukkan jumlah jawaban benar untuk setiap kategori.
            </p>

            <div class="bg-yellow-50 border border-yellow-200 p-4 rounded-lg mb-6 text-sm text-yellow-800">
                <p class="font-semibold mb-1">Detail Pembobotan:</p>
                <ul class="list-disc list-inside space-y-0.5">
                    <li>Total Soal: <span class="font-bold"><?php echo $total_soal; ?></span></li>
                    <li>Bobot Nilai Per Soal: <span class="font-bold"><?php echo number_format($nilai_per_soal, 3); ?></span> (Agar total 100)</li>
                </ul>
            </div>

            <form method="POST" action="hitung_nilai.php" class="space-y-4">
                <!-- Data tersembunyi untuk perhitungan (Bobot Soal dibawa dari langkah 1) -->
                <input type="hidden" name="pg_total_hidden" value="<?php echo $pg_total; ?>">
                <input type="hidden" name="isian_total_hidden" value="<?php echo $isian_total; ?>">
                <input type="hidden" name="essay_total_hidden" value="<?php echo $essay_total; ?>">
                <input type="hidden" name="nilai_per_soal_hidden" value="<?php echo $nilai_per_soal; ?>">
                
                <?php if ($pg_total > 0): ?>
                <div class="flex flex-col">
                    <label for="pg_benar" class="text-gray-700 font-medium mb-1">Jawaban Benar Pilihan Ganda (Max: <?php echo $pg_total; ?>):</label>
                    <!-- PERBAIKAN: value dihilangkan agar user bisa menginput angka baru tanpa terdistraksi angka default -->
                    <input type="number" id="pg_benar" name="pg_benar" required min="0" max="<?php echo $pg_total; ?>" value="" placeholder="Masukkan jumlah jawaban benar (Max: <?php echo $pg_total; ?>)"
                           class="p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 transition duration-150">
                </div>
                <?php endif; ?>

                <?php if ($isian_total > 0): ?>
                <div class="flex flex-col">
                    <label for="isian_benar" class="text-gray-700 font-medium mb-1">Jawaban Benar Isian Singkat (Max: <?php echo $isian_total; ?>):</label>
                    <!-- PERBAIKAN: value dihilangkan agar user bisa menginput angka baru tanpa terdistraksi angka default -->
                    <input type="number" id="isian_benar" name="isian_benar" required min="0" max="<?php echo $isian_total; ?>" value="" placeholder="Masukkan jumlah jawaban benar (Max: <?php echo $isian_total; ?>)"
                           class="p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 transition duration-150">
                </div>
                <?php endif; ?>

                <?php if ($essay_total > 0): ?>
                <div class="flex flex-col">
                    <label for="essay_benar" class="text-gray-700 font-medium mb-1">Jawaban Benar Esai (Max: <?php echo $essay_total; ?>):</label>
                    <!-- PERBAIKAN: value dihilangkan agar user bisa menginput angka baru tanpa terdistraksi angka default -->
                    <input type="number" id="essay_benar" name="essay_benar" required min="0" max="<?php echo $essay_total; ?>" value="" placeholder="Masukkan jumlah jawaban benar (Max: <?php echo $essay_total; ?>)"
                           class="p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 transition duration-150">
                </div>
                <?php endif; ?>

                <button type="submit" name="submit_hasil" 
                        class="w-full bg-green-600 hover:bg-green-700 text-white font-bold py-3 rounded-lg transition duration-200 shadow-md transform hover:scale-[1.01]">
                    Hitung Hasil Nilai
                </button>
            </form>

        <?php elseif ($tahap === 3): ?>
            <!-- TAHAP 3: TAMPILKAN HASIL -->
            <div class="text-center">
                <h2 class="text-2xl font-semibold text-gray-800 mb-4">Hasil Perhitungan Nilai</h2>
                
                <div class="bg-indigo-100 p-6 rounded-xl shadow-inner mb-6">
                    <p class="text-lg text-indigo-700 mb-2">Total Nilai Anda adalah:</p>
                    <p class="text-6xl font-extrabold text-indigo-900"><?php echo number_format($nilai_akhir, 2); ?></p>
                </div>

                <div class="space-y-3 text-left text-gray-700 border-t pt-4">
                    <p class="text-xl font-bold text-gray-800">Detail Pembobotan dan Jawaban:</p>
                    <p>Total Soal Keseluruhan: <span class="font-bold"><?php echo $total_soal; ?></span></p>
                    <p>Nilai Per Soal (Bobot Proposional): <span class="font-bold"><?php echo number_format($nilai_per_soal, 3); ?></span></p>
                    
                    <ul class="list-disc list-inside ml-4 pt-2">
                        <li><span class="font-semibold">Pilihan Ganda (PG):</span> Benar <span class="font-bold text-green-600"><?php echo $pg_benar; ?></span> dari <span class="font-bold"><?php echo $pg_total; ?></span> soal.</li>
                        <li><span class="font-semibold">Isian Singkat:</span> Benar <span class="font-bold text-green-600"><?php echo $isian_benar; ?></span> dari <span class="font-bold"><?php echo $isian_total; ?></span> soal.</li>
                        <li><span class="font-semibold">Esai:</span> Benar <span class="font-bold text-green-600"><?php echo $essay_benar; ?></span> dari <span class="font-bold"><?php echo $essay_total; ?></span> soal.</li>
                        <li><span class="font-semibold">Total Benar:</span> <span class="font-bold text-green-600"><?php echo $total_benar; ?></span> soal.</li>
                    </ul>
                </div>
                
                <a href="hitung_nilai.php" 
                   class="mt-6 inline-block w-full bg-gray-500 hover:bg-gray-600 text-white font-bold py-3 rounded-lg transition duration-200 shadow-md transform hover:scale-[1.01]">
                    Hitung Ulang Nilai
                </a>
            </div>

        <?php endif; ?>

    </div>
</body>
</html>
