<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Portal</title>
    <style>
        /* --- Import Font Google untuk Typography yang Lebih Baik --- */
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap');

        /* --- Variabel CSS untuk Warna Tema --- */
        :root {
            --primary-color: #667eea;
            --secondary-color: #764ba2;
            --text-color: #ffffff;
            --text-color-light: rgba(255, 255, 255, 0.7);
            --error-color: #ff4757;
            --glass-bg: rgba(255, 255, 255, 0.1);
            --glass-border: rgba(255, 255, 255, 0.2);
        }

        /* --- Gaya Umum & Latar Belakang Animasi --- */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(45deg, #1a1a2e, #16213e, #0f3460);
            color: var(--text-color);
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            overflow: hidden;
            padding: 1rem;
        }

        /* Latar belakang animasi dengan "bola cahaya" bergerak */
        .bg-animation {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: -1;
        }

        .bg-animation::before {
            content: '';
            position: absolute;
            width: 400px;
            height: 400px;
            background: radial-gradient(circle, var(--primary-color), transparent);
            border-radius: 50%;
            top: -150px;
            right: -150px;
            animation: move 10s infinite alternate;
        }

        .bg-animation::after {
            content: '';
            position: absolute;
            width: 350px;
            height: 350px;
            background: radial-gradient(circle, var(--secondary-color), transparent);
            border-radius: 50%;
            bottom: -100px;
            left: -100px;
            animation: move 12s infinite alternate-reverse;
        }

        @keyframes move {
            0% { transform: translate(0, 0) scale(1); }
            100% { transform: translate(50px, 50px) scale(1.2); }
        }

        /* --- Kotak Form Login dengan Efek Glassmorphism --- */
        .login-container {
            background: var(--glass-bg);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid var(--glass-border);
            padding: 2.5rem 2rem;
            border-radius: 20px;
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.37);
            width: 100%;
            max-width: 420px;
            text-align: center;
            animation: slideIn 0.5s ease-out;
        }

        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(-30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* --- Judul --- */
        h2 {
            font-weight: 600;
            font-size: 2rem;
            margin-bottom: 0.5rem;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .subtitle {
            color: var(--text-color-light);
            font-size: 0.9rem;
            margin-bottom: 2rem;
        }

        /* --- Grup Form --- */
        .form-group {
            position: relative;
            margin-bottom: 1.5rem;
            text-align: left;
        }

        label {
            display: block;
            margin-bottom: 0.5rem;
            color: var(--text-color-light);
            font-weight: 400;
            font-size: 0.9rem;
        }

        /* --- Input Wrapper untuk Posisi Ikon --- */
        .input-wrapper {
            position: relative;
            width: 100%;
        }

        /* --- Ikon di dalam Input --- */
        .input-icon {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-color-light);
            pointer-events: none;
            z-index: 1;
        }

        /* --- Input Field --- */
        input[type="password"] {
            width: 100%;
            padding: 0.9rem 0.9rem 0.9rem 3rem;
            border: 1px solid var(--glass-border);
            border-radius: 10px;
            background: rgba(255, 255, 255, 0.05);
            color: var(--text-color);
            font-size: 1rem;
            transition: border-color 0.3s ease, background-color 0.3s ease, box-shadow 0.3s ease;
        }

        input[type="password"]::placeholder {
            color: rgba(255, 255, 255, 0.4);
        }

        input[type="password"]:focus {
            outline: none;
            border-color: var(--primary-color);
            background: rgba(255, 255, 255, 0.1);
            box-shadow: 0 0 15px rgba(102, 126, 234, 0.4);
        }

        /* --- Tombol Login --- */
        button {
            width: 100%;
            padding: 1rem;
            border: none;
            border-radius: 10px;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            color: white;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-top: 1rem;
        }

        button:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
        }

        button:active {
            transform: translateY(-1px);
        }

        button:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }

        /* --- Pesan Error dengan Tema Glass --- */
        .error-message {
            color: #ffb3b3;
            text-align: center;
            margin-top: 1.2rem;
            font-size: 0.9rem;
            background: rgba(255, 71, 87, 0.1);
            padding: 0.7rem;
            border-radius: 8px;
            border: 1px solid rgba(255, 71, 87, 0.3);
            animation: shake 0.5s;
            display: none;
        }

        .error-message.show {
            display: block;
        }

        /* Animasi getar untuk pesan error */
        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            10%, 30%, 50%, 70%, 90% { transform: translateX(-5px); }
            20%, 40%, 60%, 80% { transform: translateX(5px); }
        }

        /* --- Responsiveness --- */
        @media (max-width: 480px) {
            .login-container {
                padding: 2rem 1.5rem;
            }

            h2 {
                font-size: 1.7rem;
            }

            .subtitle {
                font-size: 0.85rem;
            }
        }

    </style>
</head>
<body>

    <div class="bg-animation"></div>

    <div class="login-container">
        <h2>Selamat Datang</h2>
        <p class="subtitle">Masukkan kata sandi Anda untuk melanjutkan</p>
        
        <form id="loginForm" action="dashboard_db.php" method="POST">
            <div class="form-group">
                <label for="password">Kata Sandi</label>
                <div class="input-wrapper">
                    <svg class="input-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
                        <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                    </svg>
                    <input type="password" id="password" name="password" placeholder="Masukkan kata sandi" required>
                </div>
            </div>
            <button type="submit">Masuk</button>
        </form>

        <p class="error-message" id="errorMessage">Kata sandi salah! Silakan coba lagi.</p>
    </div>

    <script>
        // Tampilkan pesan error jika ada parameter error di URL
        const urlParams = new URLSearchParams(window.location.search);
        if (urlParams.get('error') === '1') {
            document.getElementById('errorMessage').classList.add('show');
        }

        // Validasi form sederhana
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            const password = document.getElementById('password').value;
            if (password.trim() === '') {
                e.preventDefault();
                document.getElementById('errorMessage').textContent = 'Kata sandi tidak boleh kosong!';
                document.getElementById('errorMessage').classList.add('show');
            }
        });
    </script>

</body>
</html>