<?php
// --- KONFIGURASI ---
define('DATA_FILE', 'data.json');
// Ganti 'rahasiaguru123' dengan password yang Anda inginkan
define('DELETE_PASSWORD', 'lopyu'); 

// Inisialisasi variabel
 $nama = $jenis_kelamin = $nisn = "";
// TAMBAHAN: Inisialisasi variabel kelas
 $kelas = "";
 $nama_err = $jenis_kelamin_err = $nisn_err = "";
// TAMBAHAN: Inisialisasi variabel error kelas
 $kelas_err = "";
 $success_message = "";

// --- PROSES HAPUS DATA VIA AJAX ---
// Cek apakah ini adalah request AJAX untuk menghapus data
if (isset($_GET['action']) && $_GET['action'] == 'clear_ajax') {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $password = $_POST['password'] ?? '';
        header('Content-Type: application/json');
        if ($password === DELETE_PASSWORD) {
            if (file_exists(DATA_FILE)) {
                if (unlink(DATA_FILE)) {
                    echo json_encode(['status' => 'success', 'message' => 'Data berhasil dihapus.']);
                } else {
                    echo json_encode(['status' => 'error', 'message' => 'Gagal menghapus file. Periksa izin folder.']);
                }
            } else {
                echo json_encode(['status' => 'success', 'message' => 'Tidak ada data yang dihapus.']);
            }
        } else {
            http_response_code(401);
            echo json_encode(['status' => 'error', 'message' => 'Password salah!']);
        }
    }
    exit;
}

// --- FUNGSI UNTUK MEMBACA DATA DARI JSON ---
function bacaData() {
    if (!file_exists(DATA_FILE)) {
        return [];
    }
    $json_data = file_get_contents(DATA_FILE);
    return json_decode($json_data, true) ?? [];
}

// --- PROSES SIMPAN DATA (JIKA FORM DI-SUBMIT) ---
if ($_SERVER["REQUEST_METHOD"] == "POST" && !isset($_GET['action'])) {

    // --- VALIDASI INPUT ---
    if (empty(trim($_POST["nama"]))) {
        $nama_err = "Nama tidak boleh kosong.";
    } else {
        $nama = trim($_POST["nama"]);
    }

    if (empty($_POST["jenis_kelamin"])) {
        $jenis_kelamin_err = "Jenis kelamin harus dipilih.";
    } else {
        $jenis_kelamin = $_POST["jenis_kelamin"];
    }

    if (empty(trim($_POST["nisn"]))) {
        $nisn_err = "NISN tidak boleh kosong.";
    } elseif (!ctype_digit($_POST["nisn"])) {
        $nisn_err = "NISN harus berupa angka.";
    } else {
        $nisn = trim($_POST["nisn"]);
    }

    // TAMBAHAN: Validasi Kelas
    if (empty(trim($_POST["kelas"]))) {
        $kelas_err = "Kelas tidak boleh kosong.";
    } else {
        $kelas = trim($_POST["kelas"]);
    }

    // --- JIKA TIDAK ADA ERROR, SIMPAN KE JSON ---
    if (empty($nama_err) && empty($jenis_kelamin_err) && empty($nisn_err) && empty($kelas_err)) {
        
        $data_siswa = bacaData();

        $data_baru = [
            'id' => uniqid(),
            'nama' => htmlspecialchars($nama),
            'jenis_kelamin' => htmlspecialchars($jenis_kelamin),
            'nisn' => htmlspecialchars($nisn),
            // TAMBAHAN: Tambahkan kelas ke data baru
            'kelas' => htmlspecialchars($kelas),
            'tanggal_input' => date('Y-m-d H:i:s')
        ];

        $data_siswa[] = $data_baru;
        $json_data = json_encode($data_siswa, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
        
        if (file_put_contents(DATA_FILE, $json_data)) {
            $success_message = "Data berhasil disimpan!";
            // Reset form setelah berhasil
            $nama = $jenis_kelamin = $nisn = $kelas = "";
        } else {
            $success_message = "<span style='color:red;'>Gagal menyimpan data. Periksa izin folder.</span>";
        }
    }
}

// Baca semua data untuk ditampilkan di tabel
 $semua_data = bacaData();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Form Input & Tampil Data (JSON)</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f9; margin: 0; padding: 20px; }
        .container { background: white; padding: 2em; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); max-width: 800px; margin: 20px auto; }
        h2 { text-align: center; color: #333; }
        .form-group { margin-bottom: 1em; }
        label { display: block; margin-bottom: 0.5em; color: #555; }
        input[type="text"] { width: 100%; padding: 0.8em; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        .radio-group label { display: inline-block; margin-right: 1.5em; }
        button { width: 100%; padding: 0.8em; background-color: #007BFF; color: white; border: none; border-radius: 4px; cursor: pointer; font-size: 1em; }
        button:hover { background-color: #0056b3; }
        .error { color: #D8000C; font-size: 0.9em; margin-top: 0.2em; }
        .success { background-color: #DFF2BF; color: #4F8A10; padding: 1em; border: 1px solid #4F8A10; border-radius: 4px; margin-bottom: 1em; text-align: center; }
        .data-table { margin-top: 2em; width: 100%; border-collapse: collapse; }
        .data-table th, .data-table td { border: 1px solid #ddd; padding: 12px; text-align: left; }
        .data-table th { background-color: #f2f2f2; }
        .data-table tr:nth-child(even) { background-color: #f9f9f9; }
        .no-data { text-align: center; color: #888; padding: 2em; }
        .actions { text-align: right; margin-top: 1em; }
        .actions a { text-decoration: none; color: #dc3545; font-size: 0.9em; font-weight: bold; }
    </style>
</head>
<body>

<div class="container">
    <h2>Form Input Data Siswa</h2>

    <?php 
    if (!empty($success_message)) {
        echo '<div class="success">' . $success_message . '</div>';
    }
    ?>

    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
        <div class="form-group">
            <label for="nama">Nama Lengkap:</label>
            <input type="text" id="nama" name="nama" value="<?php echo htmlspecialchars($nama); ?>">
            <span class="error"><?php echo $nama_err; ?></span>
        </div>

        <div class="form-group">
            <label>Jenis Kelamin:</label>
            <div class="radio-group">
                <input type="radio" id="laki-laki" name="jenis_kelamin" value="Laki-laki" <?php if (isset($jenis_kelamin) && $jenis_kelamin == "Laki-laki") echo 'checked'; ?>>
                <label for="laki-laki">Laki-laki</label>
                <input type="radio" id="perempuan" name="jenis_kelamin" value="Perempuan" <?php if (isset($jenis_kelamin) && $jenis_kelamin == "Perempuan") echo 'checked'; ?>>
                <label for="perempuan">Perempuan</label>
            </div>
            <span class="error"><?php echo $jenis_kelamin_err; ?></span>
        </div>

        <div class="form-group">
            <label for="nisn">NISN:</label>
            <input type="text" id="nisn" name="nisn" value="<?php echo htmlspecialchars($nisn); ?>">
            <span class="error"><?php echo $nisn_err; ?></span>
        </div>

        <!-- TAMBAHAN: Input field untuk Kelas -->
        <div class="form-group">
            <label for="kelas">Kelas:</label>
            <input type="text" id="kelas" name="kelas" placeholder="Contoh: XII RPL 1" value="<?php echo htmlspecialchars($kelas); ?>">
            <span class="error"><?php echo $kelas_err; ?></span>
        </div>

        <button type="submit">Simpan Data</button>
    </form>
</div>

<div class="container">
    <h2>Data Tersimpan</h2>
    <?php if (!empty($semua_data)): ?>
        <table class="data-table">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Nama</th>
                    <th>Jenis Kelamin</th>
                    <th>NISN</th>
                    <!-- TAMBAHAN: Header untuk Kolom Kelas -->
                    <th>Kelas</th>
                    <th>Tanggal Input</th>
                </tr>
            </thead>
            <tbody>
                <?php $no = 1; foreach ($semua_data as $siswa): ?>
                <tr>
                    <td><?php echo $no++; ?></td>
                    <td><?php echo $siswa['nama']; ?></td>
                    <td><?php echo $siswa['jenis_kelamin']; ?></td>
                    <td><?php echo $siswa['nisn']; ?></td>
                    <!-- TAMBAHAN: Tampilkan data kelas -->
                    <td><?php echo $siswa['kelas']; ?></td>
                    <td><?php echo $siswa['tanggal_input']; ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <div class="actions">
            <a href="#" onclick="confirmDelete(event); return false;">Hapus Semua Data</a>
        </div>
    <?php else: ?>
        <p class="no-data">Belum ada data. Silakan input data melalui form di atas.</p>
    <?php endif; ?>
</div>

<!-- JavaScript untuk konfirmasi password (tidak berubah) -->
<script>
function confirmDelete(event) {
    event.preventDefault();
    const password = prompt("Masukkan password untuk menghapus semua data:\n\nHubungi gurumu untuk mendapatkan password.");
    if (!password) {
        return;
    }
    fetch('index.php?action=clear_ajax', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded', },
        body: new URLSearchParams({ password: password })
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === 'success') {
            alert(data.message);
            window.location.reload();
        } else {
            alert(data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Terjadi kesalahan pada server. Silakan coba lagi.');
    });
}
</script>

</body>
</html>