<?php
// FILE: qr_process.php - Mencatat Kehadiran
require_once 'db.php'; 
date_default_timezone_set('Asia/Jakarta'); 

$response = [
    'success' => false,
    'message' => 'Status Kehadiran',
    'siswa_name' => '',
    'current_status' => '',
];

$siswa_id = $_GET['id'] ?? null;
$tanggal = date('Y-m-d');
$bulan = date('Y-m');
$status_hadir = 'H';

if (!$siswa_id || !is_numeric($siswa_id)) {
    $response['message'] = "ID Siswa tidak valid atau kosong.";
    // Ganti penggunaan goto dengan return
    echo json_encode($response);
    exit;
}

try {
    // 1. Cek Nama Siswa
    $stmt_siswa = $pdo->prepare("SELECT nama FROM siswa WHERE siswa_id = ?");
    $stmt_siswa->execute([$siswa_id]);
    $siswa = $stmt_siswa->fetch(PDO::FETCH_ASSOC);

    if (!$siswa) {
        $response['message'] = "Siswa dengan ID " . htmlspecialchars($siswa_id) . " tidak ditemukan.";
        echo json_encode($response);
        exit;
    }

    $response['siswa_name'] = htmlspecialchars($siswa['nama']);

    // 2. Cek apakah sudah absen hari ini
    $stmt_check = $pdo->prepare("SELECT status FROM kehadiran WHERE siswa_id = ? AND tanggal = ?");
    $stmt_check->execute([$siswa_id, $tanggal]);
    $existing_status = $stmt_check->fetchColumn();

    if ($existing_status) {
        $response['success'] = true;
        $response['current_status'] = $existing_status;
        $response['message'] = "Kehadiran **sudah tercatat** hari ini. Status: " . $existing_status;
    } else {
        // 3. Catat Kehadiran
        $query = "INSERT INTO kehadiran (siswa_id, tanggal, status, bulan) VALUES (?, ?, ?, ?)";
        $stmt_insert = $pdo->prepare($query);
        
        if ($stmt_insert->execute([$siswa_id, $tanggal, $status_hadir, $bulan])) {
            $response['success'] = true;
            $response['current_status'] = $status_hadir;
            $response['message'] = "Kehadiran **BERHASIL dicatat!** Status: Hadir.";
        } else {
            $response['message'] = "Gagal mencatat kehadiran ke database.";
        }
    }

} catch (PDOException $e) {
    $response['message'] = "Database Error: " . $e->getMessage();
}

echo json_encode($response);
?>
