<?php
session_start();
require_once 'db.php';

// Cek apakah admin sudah login
if (!isset($_SESSION['is_admin_logged_in']) || $_SESSION['is_admin_logged_in'] !== true) {
    header("Location: index.php");
    exit;
}

// Ambil data kelas
 $kelas_list = $pdo->query("SELECT * FROM kelas ORDER BY nama_kelas ASC")->fetchAll(PDO::FETCH_ASSOC);
 $current_class_id = $_GET['class_id'] ?? ($kelas_list[0]['id'] ?? null);
 $kelas_data = null;
 $siswa_list = [];

if ($current_class_id) {
    $stmt_kelas = $pdo->prepare("SELECT * FROM kelas WHERE id = ?");
    $stmt_kelas->execute([$current_class_id]);
    $kelas_data = $stmt_kelas->fetch(PDO::FETCH_ASSOC);

    // Ambil data siswa di kelas terpilih
    $stmt_siswa = $pdo->prepare("SELECT * FROM siswa WHERE kelas_id = ? ORDER BY nama ASC");
    $stmt_siswa->execute([$current_class_id]);
    $siswa_list = $stmt_siswa->fetchAll(PDO::FETCH_ASSOC);
}

// =======================================================
// INTEGRASI DENGAN phpqrcode
// =======================================================

// --- JIKA MENGGUNAKAN COMPOSER (Cara A) ---
// require_once 'vendor/autoload.php';
// use Endroid\QrCode\QrCode;
// use Endroid\QrCode\Writer\PngWriter;

// --- JIKA MENGGUNAKAN DOWNLOAD MANUAL (Cara B) ---
// Pastikan path ini benar sesuai dengan struktur folder Anda
require_once 'phpqrcode/qrlib.php'; 

// =======================================================
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cetak Barcode Siswa</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        /* Sembunyikan elemen saat print */
        @media print {
            .no-print { display: none !important; }
            body { padding: 0; }
            .barcode-card {
                page-break-inside: avoid; /* Mencegah kartu terpotong */
            }
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-4 md:p-6">
        <div class="bg-white p-6 rounded-lg shadow mb-6 no-print">
            <h1 class="text-2xl font-bold text-gray-800 mb-4">Cetak Barcode Absensi Siswa</h1>
            <form method="GET" class="flex flex-col md:flex-row gap-4">
                <div class="flex-1">
                    <label class="block text-sm font-medium text-gray-700">Pilih Kelas</label>
                    <select name="class_id" onchange="this.form.submit()" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                        <?php foreach ($kelas_list as $k): ?>
                            <option value="<?= $k['id'] ?>" <?= $k['id'] == $current_class_id ? 'selected' : '' ?>>
                                <?= htmlspecialchars($k['nama_kelas']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="flex items-end">
                    <button onclick="window.print()" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition">
                        <i class="fas fa-print mr-2"></i> Cetak Halaman
                    </button>
                    <a href="index.php" class="ml-2 bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 transition">
                        <i class="fas fa-arrow-left mr-2"></i> Kembali
                    </a>
                </div>
            </form>
        </div>

        <?php if (!empty($siswa_list)): ?>
            <div class="bg-white p-6 rounded-lg shadow">
                <h2 class="text-xl font-semibold mb-4 text-center">Barcode untuk Kelas: <?= htmlspecialchars($kelas_data['nama_kelas']) ?></h2>
                <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
                    <?php foreach ($siswa_list as $siswa): ?>
                        <div class="barcode-card border border-gray-300 p-4 rounded-lg text-center">
                            <p class="font-semibold text-lg mb-2"><?= htmlspecialchars($siswa['nama']) ?></p>
                            <p class="text-xs text-gray-500 mb-3">ID: <?= htmlspecialchars($siswa['siswa_id']) ?></p>
                            
                            <!-- ======================================================= -->
                            <!-- AREA GENERATE BARCODE DENGAN phpqrcode -->
                            <!-- ======================================================= -->
                            <div class="flex justify-center">
                                <?php
                                // --- JIKA MENGGUNAKAN DOWNLOAD MANUAL (Cara B) ---
                                // Tempelkan output gambar ke buffer
                                ob_start();
                                QRcode::png($siswa['siswa_id'], null, 'L', 4, 2); // Ukuran 4, margin 2
                                $imageData = ob_get_contents();
                                ob_end_clean();
                                
                                // Tampilkan gambar sebagai tag <img> dengan Data URI
                                echo '<img src="data:image/png;base64,' . base64_encode($imageData) . '" alt="Barcode" class="max-w-full h-auto">';

                                /*
                                // --- JIKA MENGGUNAKAN COMPOSER (Cara A) ---
                                $writer = new PngWriter();
                                $qrCode = QrCode::create($siswa['siswa_id'])
                                    ->setSize(150)
                                    ->setMargin(10);
                                $result = $writer->write($qrCode);
                                echo '<img src="' . $result->getDataUri() . '" alt="Barcode">';
                                */
                                ?>
                            </div>
                            <!-- ======================================================= -->
                            <!-- AKHIR AREA GENERATE BARCODE -->
                            <!-- ======================================================= -->

                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php else: ?>
            <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4">
                <p class="text-yellow-700">Silakan pilih kelas terlebih dahulu untuk menampilkan barcode.</p>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>