<?php include 'header.php'; ?>

<div class="mb-6">
    <a href="index.php" class="text-blue-600 hover:text-blue-800">&larr; Kembali ke Daftar Sekolah</a>
    <h2 class="text-2xl font-bold text-gray-800 mt-2">Kelas di <?php echo htmlspecialchars($school['name']); ?></h2>
</div>
<div class="flex justify-between items-center mb-6">
    <h3 class="text-xl font-semibold">Daftar Kelas</h3>
    <?php if (!isset($_SESSION['is_viewer']) || !$_SESSION['is_viewer']): ?>
        <a href="index.php?action=add_class_form&school_id=<?php echo $school_id; ?>" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg transition">+ Tambah Kelas</a>
    <?php endif; ?>
</div>
<div class="overflow-x-auto shadow rounded-lg mb-8">
    <table class="min-w-full divide-y divide-gray-200">
        <thead class="bg-gray-50"><tr><th>Nama Kelas</th><th>KKM</th><th class="text-right">Aksi</th></tr></thead>
        <tbody class="bg-white divide-y divide-gray-200">
            <?php while($class = $result_classes->fetch_assoc()): ?>
            <tr>
                <td class="px-6 py-4 whitespace-nowrap"><?php echo htmlspecialchars($class['name']); ?></td>
                <td class="px-6 py-4 whitespace-nowrap"><?php echo $class['kktp']; ?></td>
                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                    <a href="index.php?action=view_class_scores&class_id=<?php echo $class['id']; ?>" class="text-indigo-600 hover:text-indigo-900">Lihat Nilai</a>
                    <?php if (!isset($_SESSION['is_viewer']) || !$_SESSION['is_viewer']): ?>
                        <a href="index.php?action=view_class_dashboard&class_id=<?php echo $class['id']; ?>" class="text-indigo-600 hover:text-indigo-900 ml-3">Kelola</a>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>

<?php include 'footer.php'; ?>